---
layout: default
title: kubernetes resource scans
nav_order: 1
---

# kubernetes resource scans (auto generated)

|     | Id          | Type     | Entity                 | Policy                                                                                                                                                                                         | IaC        | Resource Link                                                                                                                                                                                         |
|-----|-------------|----------|------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|   0 | CKV_K8S_1   | resource | PodSecurityPolicy      | Do not admit containers wishing to share the host process ID namespace                                                                                                                         | Kubernetes | [ShareHostPIDPSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostPIDPSP.py)                                                                     |
|   1 | CKV_K8S_2   | resource | PodSecurityPolicy      | Do not admit privileged containers                                                                                                                                                             | Kubernetes | [PrivilegedContainersPSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainersPSP.py)                                                     |
|   2 | CKV_K8S_3   | resource | PodSecurityPolicy      | Do not admit containers wishing to share the host IPC namespace                                                                                                                                | Kubernetes | [ShareHostIPCPSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostIPCPSP.py)                                                                     |
|   3 | CKV_K8S_4   | resource | PodSecurityPolicy      | Do not admit containers wishing to share the host network namespace                                                                                                                            | Kubernetes | [SharedHostNetworkNamespacePSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SharedHostNetworkNamespacePSP.py)                                         |
|   4 | CKV_K8S_5   | resource | PodSecurityPolicy      | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalationPSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalationPSP.py)                                             |
|   5 | CKV_K8S_6   | resource | PodSecurityPolicy      | Do not admit root containers                                                                                                                                                                   | Kubernetes | [RootContainersPSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainersPSP.py)                                                                 |
|   6 | CKV_K8S_7   | resource | PodSecurityPolicy      | Do not admit containers with the NET_RAW capability                                                                                                                                            | Kubernetes | [DropCapabilitiesPSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilitiesPSP.py)                                                             |
|   7 | CKV_K8S_8   | resource | DaemonSet              | Liveness Probe Should be Configured                                                                                                                                                            | Kubernetes | [LivenessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/LivenessProbe.py)                                                                         |
|   8 | CKV_K8S_8   | resource | Deployment             | Liveness Probe Should be Configured                                                                                                                                                            | Kubernetes | [LivenessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/LivenessProbe.py)                                                                         |
|   9 | CKV_K8S_8   | resource | DeploymentConfig       | Liveness Probe Should be Configured                                                                                                                                                            | Kubernetes | [LivenessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/LivenessProbe.py)                                                                         |
|  10 | CKV_K8S_8   | resource | Pod                    | Liveness Probe Should be Configured                                                                                                                                                            | Kubernetes | [LivenessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/LivenessProbe.py)                                                                         |
|  11 | CKV_K8S_8   | resource | PodTemplate            | Liveness Probe Should be Configured                                                                                                                                                            | Kubernetes | [LivenessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/LivenessProbe.py)                                                                         |
|  12 | CKV_K8S_8   | resource | ReplicaSet             | Liveness Probe Should be Configured                                                                                                                                                            | Kubernetes | [LivenessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/LivenessProbe.py)                                                                         |
|  13 | CKV_K8S_8   | resource | ReplicationController  | Liveness Probe Should be Configured                                                                                                                                                            | Kubernetes | [LivenessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/LivenessProbe.py)                                                                         |
|  14 | CKV_K8S_8   | resource | StatefulSet            | Liveness Probe Should be Configured                                                                                                                                                            | Kubernetes | [LivenessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/LivenessProbe.py)                                                                         |
|  15 | CKV_K8S_9   | resource | DaemonSet              | Readiness Probe Should be Configured                                                                                                                                                           | Kubernetes | [ReadinessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadinessProbe.py)                                                                       |
|  16 | CKV_K8S_9   | resource | Deployment             | Readiness Probe Should be Configured                                                                                                                                                           | Kubernetes | [ReadinessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadinessProbe.py)                                                                       |
|  17 | CKV_K8S_9   | resource | DeploymentConfig       | Readiness Probe Should be Configured                                                                                                                                                           | Kubernetes | [ReadinessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadinessProbe.py)                                                                       |
|  18 | CKV_K8S_9   | resource | Pod                    | Readiness Probe Should be Configured                                                                                                                                                           | Kubernetes | [ReadinessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadinessProbe.py)                                                                       |
|  19 | CKV_K8S_9   | resource | PodTemplate            | Readiness Probe Should be Configured                                                                                                                                                           | Kubernetes | [ReadinessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadinessProbe.py)                                                                       |
|  20 | CKV_K8S_9   | resource | ReplicaSet             | Readiness Probe Should be Configured                                                                                                                                                           | Kubernetes | [ReadinessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadinessProbe.py)                                                                       |
|  21 | CKV_K8S_9   | resource | ReplicationController  | Readiness Probe Should be Configured                                                                                                                                                           | Kubernetes | [ReadinessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadinessProbe.py)                                                                       |
|  22 | CKV_K8S_9   | resource | StatefulSet            | Readiness Probe Should be Configured                                                                                                                                                           | Kubernetes | [ReadinessProbe.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadinessProbe.py)                                                                       |
|  23 | CKV_K8S_10  | resource | CronJob                | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  24 | CKV_K8S_10  | resource | DaemonSet              | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  25 | CKV_K8S_10  | resource | Deployment             | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  26 | CKV_K8S_10  | resource | DeploymentConfig       | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  27 | CKV_K8S_10  | resource | Job                    | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  28 | CKV_K8S_10  | resource | Pod                    | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  29 | CKV_K8S_10  | resource | PodTemplate            | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  30 | CKV_K8S_10  | resource | ReplicaSet             | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  31 | CKV_K8S_10  | resource | ReplicationController  | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  32 | CKV_K8S_10  | resource | StatefulSet            | CPU requests should be set                                                                                                                                                                     | Kubernetes | [CPURequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPURequests.py)                                                                             |
|  33 | CKV_K8S_11  | resource | CronJob                | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  34 | CKV_K8S_11  | resource | DaemonSet              | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  35 | CKV_K8S_11  | resource | Deployment             | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  36 | CKV_K8S_11  | resource | DeploymentConfig       | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  37 | CKV_K8S_11  | resource | Job                    | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  38 | CKV_K8S_11  | resource | Pod                    | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  39 | CKV_K8S_11  | resource | PodTemplate            | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  40 | CKV_K8S_11  | resource | ReplicaSet             | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  41 | CKV_K8S_11  | resource | ReplicationController  | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  42 | CKV_K8S_11  | resource | StatefulSet            | CPU limits should be set                                                                                                                                                                       | Kubernetes | [CPULimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/CPULimits.py)                                                                                 |
|  43 | CKV_K8S_12  | resource | CronJob                | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  44 | CKV_K8S_12  | resource | DaemonSet              | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  45 | CKV_K8S_12  | resource | Deployment             | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  46 | CKV_K8S_12  | resource | DeploymentConfig       | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  47 | CKV_K8S_12  | resource | Job                    | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  48 | CKV_K8S_12  | resource | Pod                    | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  49 | CKV_K8S_12  | resource | PodTemplate            | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  50 | CKV_K8S_12  | resource | ReplicaSet             | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  51 | CKV_K8S_12  | resource | ReplicationController  | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  52 | CKV_K8S_12  | resource | StatefulSet            | Memory requests should be set                                                                                                                                                                  | Kubernetes | [MemoryRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryRequests.py)                                                                       |
|  53 | CKV_K8S_13  | resource | CronJob                | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  54 | CKV_K8S_13  | resource | DaemonSet              | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  55 | CKV_K8S_13  | resource | Deployment             | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  56 | CKV_K8S_13  | resource | DeploymentConfig       | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  57 | CKV_K8S_13  | resource | Job                    | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  58 | CKV_K8S_13  | resource | Pod                    | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  59 | CKV_K8S_13  | resource | PodTemplate            | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  60 | CKV_K8S_13  | resource | ReplicaSet             | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  61 | CKV_K8S_13  | resource | ReplicationController  | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  62 | CKV_K8S_13  | resource | StatefulSet            | Memory limits should be set                                                                                                                                                                    | Kubernetes | [MemoryLimits.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MemoryLimits.py)                                                                           |
|  63 | CKV_K8S_14  | resource | CronJob                | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  64 | CKV_K8S_14  | resource | DaemonSet              | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  65 | CKV_K8S_14  | resource | Deployment             | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  66 | CKV_K8S_14  | resource | DeploymentConfig       | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  67 | CKV_K8S_14  | resource | Job                    | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  68 | CKV_K8S_14  | resource | Pod                    | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  69 | CKV_K8S_14  | resource | PodTemplate            | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  70 | CKV_K8S_14  | resource | ReplicaSet             | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  71 | CKV_K8S_14  | resource | ReplicationController  | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  72 | CKV_K8S_14  | resource | StatefulSet            | Image Tag should be fixed - not latest or blank                                                                                                                                                | Kubernetes | [ImageTagFixed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageTagFixed.py)                                                                         |
|  73 | CKV_K8S_15  | resource | CronJob                | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  74 | CKV_K8S_15  | resource | DaemonSet              | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  75 | CKV_K8S_15  | resource | Deployment             | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  76 | CKV_K8S_15  | resource | DeploymentConfig       | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  77 | CKV_K8S_15  | resource | Job                    | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  78 | CKV_K8S_15  | resource | Pod                    | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  79 | CKV_K8S_15  | resource | PodTemplate            | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  80 | CKV_K8S_15  | resource | ReplicaSet             | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  81 | CKV_K8S_15  | resource | ReplicationController  | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  82 | CKV_K8S_15  | resource | StatefulSet            | Image Pull Policy should be Always                                                                                                                                                             | Kubernetes | [ImagePullPolicyAlways.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImagePullPolicyAlways.py)                                                         |
|  83 | CKV_K8S_16  | resource | CronJob                | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  84 | CKV_K8S_16  | resource | DaemonSet              | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  85 | CKV_K8S_16  | resource | Deployment             | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  86 | CKV_K8S_16  | resource | DeploymentConfig       | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  87 | CKV_K8S_16  | resource | Job                    | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  88 | CKV_K8S_16  | resource | Pod                    | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  89 | CKV_K8S_16  | resource | PodTemplate            | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  90 | CKV_K8S_16  | resource | ReplicaSet             | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  91 | CKV_K8S_16  | resource | ReplicationController  | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  92 | CKV_K8S_16  | resource | StatefulSet            | Container should not be privileged                                                                                                                                                             | Kubernetes | [PrivilegedContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PrivilegedContainers.py)                                                           |
|  93 | CKV_K8S_17  | resource | CronJob                | Containers should not share the host process ID namespace                                                                                                                                      | Kubernetes | [ShareHostPID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostPID.py)                                                                           |
|  94 | CKV_K8S_17  | resource | DaemonSet              | Containers should not share the host process ID namespace                                                                                                                                      | Kubernetes | [ShareHostPID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostPID.py)                                                                           |
|  95 | CKV_K8S_17  | resource | Deployment             | Containers should not share the host process ID namespace                                                                                                                                      | Kubernetes | [ShareHostPID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostPID.py)                                                                           |
|  96 | CKV_K8S_17  | resource | Job                    | Containers should not share the host process ID namespace                                                                                                                                      | Kubernetes | [ShareHostPID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostPID.py)                                                                           |
|  97 | CKV_K8S_17  | resource | Pod                    | Containers should not share the host process ID namespace                                                                                                                                      | Kubernetes | [ShareHostPID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostPID.py)                                                                           |
|  98 | CKV_K8S_17  | resource | ReplicaSet             | Containers should not share the host process ID namespace                                                                                                                                      | Kubernetes | [ShareHostPID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostPID.py)                                                                           |
|  99 | CKV_K8S_17  | resource | ReplicationController  | Containers should not share the host process ID namespace                                                                                                                                      | Kubernetes | [ShareHostPID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostPID.py)                                                                           |
| 100 | CKV_K8S_17  | resource | StatefulSet            | Containers should not share the host process ID namespace                                                                                                                                      | Kubernetes | [ShareHostPID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostPID.py)                                                                           |
| 101 | CKV_K8S_18  | resource | CronJob                | Containers should not share the host IPC namespace                                                                                                                                             | Kubernetes | [ShareHostIPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostIPC.py)                                                                           |
| 102 | CKV_K8S_18  | resource | DaemonSet              | Containers should not share the host IPC namespace                                                                                                                                             | Kubernetes | [ShareHostIPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostIPC.py)                                                                           |
| 103 | CKV_K8S_18  | resource | Deployment             | Containers should not share the host IPC namespace                                                                                                                                             | Kubernetes | [ShareHostIPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostIPC.py)                                                                           |
| 104 | CKV_K8S_18  | resource | Job                    | Containers should not share the host IPC namespace                                                                                                                                             | Kubernetes | [ShareHostIPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostIPC.py)                                                                           |
| 105 | CKV_K8S_18  | resource | Pod                    | Containers should not share the host IPC namespace                                                                                                                                             | Kubernetes | [ShareHostIPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostIPC.py)                                                                           |
| 106 | CKV_K8S_18  | resource | ReplicaSet             | Containers should not share the host IPC namespace                                                                                                                                             | Kubernetes | [ShareHostIPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostIPC.py)                                                                           |
| 107 | CKV_K8S_18  | resource | ReplicationController  | Containers should not share the host IPC namespace                                                                                                                                             | Kubernetes | [ShareHostIPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostIPC.py)                                                                           |
| 108 | CKV_K8S_18  | resource | StatefulSet            | Containers should not share the host IPC namespace                                                                                                                                             | Kubernetes | [ShareHostIPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ShareHostIPC.py)                                                                           |
| 109 | CKV_K8S_19  | resource | CronJob                | Containers should not share the host network namespace                                                                                                                                         | Kubernetes | [SharedHostNetworkNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SharedHostNetworkNamespace.py)                                               |
| 110 | CKV_K8S_19  | resource | DaemonSet              | Containers should not share the host network namespace                                                                                                                                         | Kubernetes | [SharedHostNetworkNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SharedHostNetworkNamespace.py)                                               |
| 111 | CKV_K8S_19  | resource | Deployment             | Containers should not share the host network namespace                                                                                                                                         | Kubernetes | [SharedHostNetworkNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SharedHostNetworkNamespace.py)                                               |
| 112 | CKV_K8S_19  | resource | Job                    | Containers should not share the host network namespace                                                                                                                                         | Kubernetes | [SharedHostNetworkNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SharedHostNetworkNamespace.py)                                               |
| 113 | CKV_K8S_19  | resource | Pod                    | Containers should not share the host network namespace                                                                                                                                         | Kubernetes | [SharedHostNetworkNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SharedHostNetworkNamespace.py)                                               |
| 114 | CKV_K8S_19  | resource | ReplicaSet             | Containers should not share the host network namespace                                                                                                                                         | Kubernetes | [SharedHostNetworkNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SharedHostNetworkNamespace.py)                                               |
| 115 | CKV_K8S_19  | resource | ReplicationController  | Containers should not share the host network namespace                                                                                                                                         | Kubernetes | [SharedHostNetworkNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SharedHostNetworkNamespace.py)                                               |
| 116 | CKV_K8S_19  | resource | StatefulSet            | Containers should not share the host network namespace                                                                                                                                         | Kubernetes | [SharedHostNetworkNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SharedHostNetworkNamespace.py)                                               |
| 117 | CKV_K8S_20  | resource | CronJob                | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 118 | CKV_K8S_20  | resource | DaemonSet              | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 119 | CKV_K8S_20  | resource | Deployment             | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 120 | CKV_K8S_20  | resource | DeploymentConfig       | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 121 | CKV_K8S_20  | resource | Job                    | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 122 | CKV_K8S_20  | resource | Pod                    | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 123 | CKV_K8S_20  | resource | PodTemplate            | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 124 | CKV_K8S_20  | resource | ReplicaSet             | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 125 | CKV_K8S_20  | resource | ReplicationController  | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 126 | CKV_K8S_20  | resource | StatefulSet            | Containers should not run with allowPrivilegeEscalation                                                                                                                                        | Kubernetes | [AllowPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowPrivilegeEscalation.py)                                                   |
| 127 | CKV_K8S_21  | resource | ConfigMap              | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 128 | CKV_K8S_21  | resource | CronJob                | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 129 | CKV_K8S_21  | resource | DaemonSet              | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 130 | CKV_K8S_21  | resource | Deployment             | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 131 | CKV_K8S_21  | resource | Ingress                | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 132 | CKV_K8S_21  | resource | Job                    | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 133 | CKV_K8S_21  | resource | Pod                    | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 134 | CKV_K8S_21  | resource | ReplicaSet             | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 135 | CKV_K8S_21  | resource | ReplicationController  | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 136 | CKV_K8S_21  | resource | Role                   | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 137 | CKV_K8S_21  | resource | RoleBinding            | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 138 | CKV_K8S_21  | resource | Secret                 | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 139 | CKV_K8S_21  | resource | Service                | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 140 | CKV_K8S_21  | resource | ServiceAccount         | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 141 | CKV_K8S_21  | resource | StatefulSet            | The default namespace should not be used                                                                                                                                                       | Kubernetes | [DefaultNamespace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultNamespace.py)                                                                   |
| 142 | CKV_K8S_22  | resource | CronJob                | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 143 | CKV_K8S_22  | resource | DaemonSet              | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 144 | CKV_K8S_22  | resource | Deployment             | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 145 | CKV_K8S_22  | resource | DeploymentConfig       | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 146 | CKV_K8S_22  | resource | Job                    | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 147 | CKV_K8S_22  | resource | Pod                    | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 148 | CKV_K8S_22  | resource | PodTemplate            | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 149 | CKV_K8S_22  | resource | ReplicaSet             | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 150 | CKV_K8S_22  | resource | ReplicationController  | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 151 | CKV_K8S_22  | resource | StatefulSet            | Use read-only filesystem for containers where possible                                                                                                                                         | Kubernetes | [ReadOnlyFilesystem.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ReadOnlyFilesystem.py)                                                               |
| 152 | CKV_K8S_23  | resource | CronJob                | Minimize the admission of root containers                                                                                                                                                      | Kubernetes | [RootContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainers.py)                                                                       |
| 153 | CKV_K8S_23  | resource | DaemonSet              | Minimize the admission of root containers                                                                                                                                                      | Kubernetes | [RootContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainers.py)                                                                       |
| 154 | CKV_K8S_23  | resource | Deployment             | Minimize the admission of root containers                                                                                                                                                      | Kubernetes | [RootContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainers.py)                                                                       |
| 155 | CKV_K8S_23  | resource | Job                    | Minimize the admission of root containers                                                                                                                                                      | Kubernetes | [RootContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainers.py)                                                                       |
| 156 | CKV_K8S_23  | resource | Pod                    | Minimize the admission of root containers                                                                                                                                                      | Kubernetes | [RootContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainers.py)                                                                       |
| 157 | CKV_K8S_23  | resource | ReplicaSet             | Minimize the admission of root containers                                                                                                                                                      | Kubernetes | [RootContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainers.py)                                                                       |
| 158 | CKV_K8S_23  | resource | ReplicationController  | Minimize the admission of root containers                                                                                                                                                      | Kubernetes | [RootContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainers.py)                                                                       |
| 159 | CKV_K8S_23  | resource | StatefulSet            | Minimize the admission of root containers                                                                                                                                                      | Kubernetes | [RootContainers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainers.py)                                                                       |
| 160 | CKV_K8S_24  | resource | PodSecurityPolicy      | Do not allow containers with added capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesPSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesPSP.py)                                                       |
| 161 | CKV_K8S_25  | resource | CronJob                | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 162 | CKV_K8S_25  | resource | DaemonSet              | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 163 | CKV_K8S_25  | resource | Deployment             | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 164 | CKV_K8S_25  | resource | DeploymentConfig       | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 165 | CKV_K8S_25  | resource | Job                    | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 166 | CKV_K8S_25  | resource | Pod                    | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 167 | CKV_K8S_25  | resource | PodTemplate            | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 168 | CKV_K8S_25  | resource | ReplicaSet             | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 169 | CKV_K8S_25  | resource | ReplicationController  | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 170 | CKV_K8S_25  | resource | StatefulSet            | Minimize the admission of containers with added capability                                                                                                                                     | Kubernetes | [AllowedCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilities.py)                                                             |
| 171 | CKV_K8S_26  | resource | CronJob                | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 172 | CKV_K8S_26  | resource | DaemonSet              | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 173 | CKV_K8S_26  | resource | Deployment             | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 174 | CKV_K8S_26  | resource | DeploymentConfig       | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 175 | CKV_K8S_26  | resource | Job                    | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 176 | CKV_K8S_26  | resource | Pod                    | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 177 | CKV_K8S_26  | resource | PodTemplate            | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 178 | CKV_K8S_26  | resource | ReplicaSet             | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 179 | CKV_K8S_26  | resource | ReplicationController  | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 180 | CKV_K8S_26  | resource | StatefulSet            | Do not specify hostPort unless absolutely necessary                                                                                                                                            | Kubernetes | [HostPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/HostPort.py)                                                                                   |
| 181 | CKV_K8S_27  | resource | CronJob                | Do not expose the docker daemon socket to containers                                                                                                                                           | Kubernetes | [DockerSocketVolume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DockerSocketVolume.py)                                                               |
| 182 | CKV_K8S_27  | resource | DaemonSet              | Do not expose the docker daemon socket to containers                                                                                                                                           | Kubernetes | [DockerSocketVolume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DockerSocketVolume.py)                                                               |
| 183 | CKV_K8S_27  | resource | Deployment             | Do not expose the docker daemon socket to containers                                                                                                                                           | Kubernetes | [DockerSocketVolume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DockerSocketVolume.py)                                                               |
| 184 | CKV_K8S_27  | resource | Job                    | Do not expose the docker daemon socket to containers                                                                                                                                           | Kubernetes | [DockerSocketVolume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DockerSocketVolume.py)                                                               |
| 185 | CKV_K8S_27  | resource | Pod                    | Do not expose the docker daemon socket to containers                                                                                                                                           | Kubernetes | [DockerSocketVolume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DockerSocketVolume.py)                                                               |
| 186 | CKV_K8S_27  | resource | ReplicaSet             | Do not expose the docker daemon socket to containers                                                                                                                                           | Kubernetes | [DockerSocketVolume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DockerSocketVolume.py)                                                               |
| 187 | CKV_K8S_27  | resource | ReplicationController  | Do not expose the docker daemon socket to containers                                                                                                                                           | Kubernetes | [DockerSocketVolume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DockerSocketVolume.py)                                                               |
| 188 | CKV_K8S_27  | resource | StatefulSet            | Do not expose the docker daemon socket to containers                                                                                                                                           | Kubernetes | [DockerSocketVolume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DockerSocketVolume.py)                                                               |
| 189 | CKV_K8S_28  | resource | CronJob                | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 190 | CKV_K8S_28  | resource | DaemonSet              | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 191 | CKV_K8S_28  | resource | Deployment             | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 192 | CKV_K8S_28  | resource | DeploymentConfig       | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 193 | CKV_K8S_28  | resource | Job                    | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 194 | CKV_K8S_28  | resource | Pod                    | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 195 | CKV_K8S_28  | resource | PodTemplate            | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 196 | CKV_K8S_28  | resource | ReplicaSet             | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 197 | CKV_K8S_28  | resource | ReplicationController  | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 198 | CKV_K8S_28  | resource | StatefulSet            | Minimize the admission of containers with the NET_RAW capability                                                                                                                               | Kubernetes | [DropCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DropCapabilities.py)                                                                   |
| 199 | CKV_K8S_29  | resource | CronJob                | Apply security context to your pods and containers                                                                                                                                             | Kubernetes | [PodSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PodSecurityContext.py)                                                               |
| 200 | CKV_K8S_29  | resource | DaemonSet              | Apply security context to your pods and containers                                                                                                                                             | Kubernetes | [PodSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PodSecurityContext.py)                                                               |
| 201 | CKV_K8S_29  | resource | Deployment             | Apply security context to your pods and containers                                                                                                                                             | Kubernetes | [PodSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PodSecurityContext.py)                                                               |
| 202 | CKV_K8S_29  | resource | Job                    | Apply security context to your pods and containers                                                                                                                                             | Kubernetes | [PodSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PodSecurityContext.py)                                                               |
| 203 | CKV_K8S_29  | resource | Pod                    | Apply security context to your pods and containers                                                                                                                                             | Kubernetes | [PodSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PodSecurityContext.py)                                                               |
| 204 | CKV_K8S_29  | resource | ReplicaSet             | Apply security context to your pods and containers                                                                                                                                             | Kubernetes | [PodSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PodSecurityContext.py)                                                               |
| 205 | CKV_K8S_29  | resource | ReplicationController  | Apply security context to your pods and containers                                                                                                                                             | Kubernetes | [PodSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PodSecurityContext.py)                                                               |
| 206 | CKV_K8S_29  | resource | StatefulSet            | Apply security context to your pods and containers                                                                                                                                             | Kubernetes | [PodSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PodSecurityContext.py)                                                               |
| 207 | CKV_K8S_30  | resource | CronJob                | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 208 | CKV_K8S_30  | resource | DaemonSet              | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 209 | CKV_K8S_30  | resource | Deployment             | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 210 | CKV_K8S_30  | resource | DeploymentConfig       | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 211 | CKV_K8S_30  | resource | Job                    | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 212 | CKV_K8S_30  | resource | Pod                    | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 213 | CKV_K8S_30  | resource | PodTemplate            | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 214 | CKV_K8S_30  | resource | ReplicaSet             | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 215 | CKV_K8S_30  | resource | ReplicationController  | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 216 | CKV_K8S_30  | resource | StatefulSet            | Apply security context to your containers                                                                                                                                                      | Kubernetes | [ContainerSecurityContext.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ContainerSecurityContext.py)                                                   |
| 217 | CKV_K8S_31  | resource | CronJob                | Ensure that the seccomp profile is set to docker/default or runtime/default                                                                                                                    | Kubernetes | [Seccomp.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Seccomp.py)                                                                                     |
| 218 | CKV_K8S_31  | resource | DaemonSet              | Ensure that the seccomp profile is set to docker/default or runtime/default                                                                                                                    | Kubernetes | [Seccomp.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Seccomp.py)                                                                                     |
| 219 | CKV_K8S_31  | resource | Deployment             | Ensure that the seccomp profile is set to docker/default or runtime/default                                                                                                                    | Kubernetes | [Seccomp.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Seccomp.py)                                                                                     |
| 220 | CKV_K8S_31  | resource | Job                    | Ensure that the seccomp profile is set to docker/default or runtime/default                                                                                                                    | Kubernetes | [Seccomp.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Seccomp.py)                                                                                     |
| 221 | CKV_K8S_31  | resource | Pod                    | Ensure that the seccomp profile is set to docker/default or runtime/default                                                                                                                    | Kubernetes | [Seccomp.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Seccomp.py)                                                                                     |
| 222 | CKV_K8S_31  | resource | ReplicaSet             | Ensure that the seccomp profile is set to docker/default or runtime/default                                                                                                                    | Kubernetes | [Seccomp.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Seccomp.py)                                                                                     |
| 223 | CKV_K8S_31  | resource | ReplicationController  | Ensure that the seccomp profile is set to docker/default or runtime/default                                                                                                                    | Kubernetes | [Seccomp.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Seccomp.py)                                                                                     |
| 224 | CKV_K8S_31  | resource | StatefulSet            | Ensure that the seccomp profile is set to docker/default or runtime/default                                                                                                                    | Kubernetes | [Seccomp.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Seccomp.py)                                                                                     |
| 225 | CKV_K8S_32  | resource | PodSecurityPolicy      | Ensure default seccomp profile set to docker/default or runtime/default                                                                                                                        | Kubernetes | [SeccompPSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SeccompPSP.py)                                                                               |
| 226 | CKV_K8S_33  | resource | CronJob                | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 227 | CKV_K8S_33  | resource | DaemonSet              | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 228 | CKV_K8S_33  | resource | Deployment             | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 229 | CKV_K8S_33  | resource | DeploymentConfig       | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 230 | CKV_K8S_33  | resource | Job                    | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 231 | CKV_K8S_33  | resource | Pod                    | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 232 | CKV_K8S_33  | resource | PodTemplate            | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 233 | CKV_K8S_33  | resource | ReplicaSet             | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 234 | CKV_K8S_33  | resource | ReplicationController  | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 235 | CKV_K8S_33  | resource | StatefulSet            | Ensure the Kubernetes dashboard is not deployed                                                                                                                                                | Kubernetes | [KubernetesDashboard.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubernetesDashboard.py)                                                             |
| 236 | CKV_K8S_34  | resource | CronJob                | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 237 | CKV_K8S_34  | resource | DaemonSet              | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 238 | CKV_K8S_34  | resource | Deployment             | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 239 | CKV_K8S_34  | resource | DeploymentConfig       | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 240 | CKV_K8S_34  | resource | Job                    | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 241 | CKV_K8S_34  | resource | Pod                    | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 242 | CKV_K8S_34  | resource | PodTemplate            | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 243 | CKV_K8S_34  | resource | ReplicaSet             | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 244 | CKV_K8S_34  | resource | ReplicationController  | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 245 | CKV_K8S_34  | resource | StatefulSet            | Ensure that Tiller (Helm v2) is not deployed                                                                                                                                                   | Kubernetes | [Tiller.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Tiller.py)                                                                                       |
| 246 | CKV_K8S_35  | resource | CronJob                | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 247 | CKV_K8S_35  | resource | DaemonSet              | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 248 | CKV_K8S_35  | resource | Deployment             | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 249 | CKV_K8S_35  | resource | DeploymentConfig       | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 250 | CKV_K8S_35  | resource | Job                    | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 251 | CKV_K8S_35  | resource | Pod                    | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 252 | CKV_K8S_35  | resource | PodTemplate            | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 253 | CKV_K8S_35  | resource | ReplicaSet             | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 254 | CKV_K8S_35  | resource | ReplicationController  | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 255 | CKV_K8S_35  | resource | StatefulSet            | Prefer using secrets as files over secrets as environment variables                                                                                                                            | Kubernetes | [Secrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/Secrets.py)                                                                                     |
| 256 | CKV_K8S_36  | resource | PodSecurityPolicy      | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilitiesPSP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilitiesPSP.py)                                                     |
| 257 | CKV_K8S_37  | resource | CronJob                | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 258 | CKV_K8S_37  | resource | DaemonSet              | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 259 | CKV_K8S_37  | resource | Deployment             | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 260 | CKV_K8S_37  | resource | DeploymentConfig       | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 261 | CKV_K8S_37  | resource | Job                    | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 262 | CKV_K8S_37  | resource | Pod                    | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 263 | CKV_K8S_37  | resource | PodTemplate            | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 264 | CKV_K8S_37  | resource | ReplicaSet             | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 265 | CKV_K8S_37  | resource | ReplicationController  | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 266 | CKV_K8S_37  | resource | StatefulSet            | Minimize the admission of containers with capabilities assigned                                                                                                                                | Kubernetes | [MinimizeCapabilities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/MinimizeCapabilities.py)                                                           |
| 267 | CKV_K8S_38  | resource | CronJob                | Ensure that Service Account Tokens are only mounted where necessary                                                                                                                            | Kubernetes | [ServiceAccountTokens.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ServiceAccountTokens.py)                                                           |
| 268 | CKV_K8S_38  | resource | DaemonSet              | Ensure that Service Account Tokens are only mounted where necessary                                                                                                                            | Kubernetes | [ServiceAccountTokens.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ServiceAccountTokens.py)                                                           |
| 269 | CKV_K8S_38  | resource | Deployment             | Ensure that Service Account Tokens are only mounted where necessary                                                                                                                            | Kubernetes | [ServiceAccountTokens.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ServiceAccountTokens.py)                                                           |
| 270 | CKV_K8S_38  | resource | Job                    | Ensure that Service Account Tokens are only mounted where necessary                                                                                                                            | Kubernetes | [ServiceAccountTokens.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ServiceAccountTokens.py)                                                           |
| 271 | CKV_K8S_38  | resource | Pod                    | Ensure that Service Account Tokens are only mounted where necessary                                                                                                                            | Kubernetes | [ServiceAccountTokens.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ServiceAccountTokens.py)                                                           |
| 272 | CKV_K8S_38  | resource | ReplicaSet             | Ensure that Service Account Tokens are only mounted where necessary                                                                                                                            | Kubernetes | [ServiceAccountTokens.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ServiceAccountTokens.py)                                                           |
| 273 | CKV_K8S_38  | resource | ReplicationController  | Ensure that Service Account Tokens are only mounted where necessary                                                                                                                            | Kubernetes | [ServiceAccountTokens.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ServiceAccountTokens.py)                                                           |
| 274 | CKV_K8S_38  | resource | StatefulSet            | Ensure that Service Account Tokens are only mounted where necessary                                                                                                                            | Kubernetes | [ServiceAccountTokens.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ServiceAccountTokens.py)                                                           |
| 275 | CKV_K8S_39  | resource | CronJob                | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 276 | CKV_K8S_39  | resource | DaemonSet              | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 277 | CKV_K8S_39  | resource | Deployment             | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 278 | CKV_K8S_39  | resource | DeploymentConfig       | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 279 | CKV_K8S_39  | resource | Job                    | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 280 | CKV_K8S_39  | resource | Pod                    | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 281 | CKV_K8S_39  | resource | PodTemplate            | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 282 | CKV_K8S_39  | resource | ReplicaSet             | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 283 | CKV_K8S_39  | resource | ReplicationController  | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 284 | CKV_K8S_39  | resource | StatefulSet            | Do not use the CAP_SYS_ADMIN linux capability                                                                                                                                                  | Kubernetes | [AllowedCapabilitiesSysAdmin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/AllowedCapabilitiesSysAdmin.py)                                             |
| 285 | CKV_K8S_40  | resource | CronJob                | Containers should run as a high UID to avoid host conflict                                                                                                                                     | Kubernetes | [RootContainersHighUID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainersHighUID.py)                                                         |
| 286 | CKV_K8S_40  | resource | DaemonSet              | Containers should run as a high UID to avoid host conflict                                                                                                                                     | Kubernetes | [RootContainersHighUID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainersHighUID.py)                                                         |
| 287 | CKV_K8S_40  | resource | Deployment             | Containers should run as a high UID to avoid host conflict                                                                                                                                     | Kubernetes | [RootContainersHighUID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainersHighUID.py)                                                         |
| 288 | CKV_K8S_40  | resource | Job                    | Containers should run as a high UID to avoid host conflict                                                                                                                                     | Kubernetes | [RootContainersHighUID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainersHighUID.py)                                                         |
| 289 | CKV_K8S_40  | resource | Pod                    | Containers should run as a high UID to avoid host conflict                                                                                                                                     | Kubernetes | [RootContainersHighUID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainersHighUID.py)                                                         |
| 290 | CKV_K8S_40  | resource | ReplicaSet             | Containers should run as a high UID to avoid host conflict                                                                                                                                     | Kubernetes | [RootContainersHighUID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainersHighUID.py)                                                         |
| 291 | CKV_K8S_40  | resource | ReplicationController  | Containers should run as a high UID to avoid host conflict                                                                                                                                     | Kubernetes | [RootContainersHighUID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainersHighUID.py)                                                         |
| 292 | CKV_K8S_40  | resource | StatefulSet            | Containers should run as a high UID to avoid host conflict                                                                                                                                     | Kubernetes | [RootContainersHighUID.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RootContainersHighUID.py)                                                         |
| 293 | CKV_K8S_41  | resource | ServiceAccount         | Ensure that default service accounts are not actively used                                                                                                                                     | Kubernetes | [DefaultServiceAccount.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultServiceAccount.py)                                                         |
| 294 | CKV_K8S_42  | resource | ClusterRoleBinding     | Ensure that default service accounts are not actively used                                                                                                                                     | Kubernetes | [DefaultServiceAccountBinding.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultServiceAccountBinding.py)                                           |
| 295 | CKV_K8S_42  | resource | RoleBinding            | Ensure that default service accounts are not actively used                                                                                                                                     | Kubernetes | [DefaultServiceAccountBinding.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DefaultServiceAccountBinding.py)                                           |
| 296 | CKV_K8S_43  | resource | CronJob                | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 297 | CKV_K8S_43  | resource | DaemonSet              | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 298 | CKV_K8S_43  | resource | Deployment             | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 299 | CKV_K8S_43  | resource | DeploymentConfig       | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 300 | CKV_K8S_43  | resource | Job                    | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 301 | CKV_K8S_43  | resource | Pod                    | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 302 | CKV_K8S_43  | resource | PodTemplate            | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 303 | CKV_K8S_43  | resource | ReplicaSet             | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 304 | CKV_K8S_43  | resource | ReplicationController  | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 305 | CKV_K8S_43  | resource | StatefulSet            | Image should use digest                                                                                                                                                                        | Kubernetes | [ImageDigest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ImageDigest.py)                                                                             |
| 306 | CKV_K8S_44  | resource | Service                | Ensure that the Tiller Service (Helm v2) is deleted                                                                                                                                            | Kubernetes | [TillerService.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerService.py)                                                                         |
| 307 | CKV_K8S_45  | resource | CronJob                | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 308 | CKV_K8S_45  | resource | DaemonSet              | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 309 | CKV_K8S_45  | resource | Deployment             | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 310 | CKV_K8S_45  | resource | DeploymentConfig       | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 311 | CKV_K8S_45  | resource | Job                    | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 312 | CKV_K8S_45  | resource | Pod                    | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 313 | CKV_K8S_45  | resource | PodTemplate            | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 314 | CKV_K8S_45  | resource | ReplicaSet             | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 315 | CKV_K8S_45  | resource | ReplicationController  | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 316 | CKV_K8S_45  | resource | StatefulSet            | Ensure the Tiller Deployment (Helm V2) is not accessible from within the cluster                                                                                                               | Kubernetes | [TillerDeploymentListener.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/TillerDeploymentListener.py)                                                   |
| 317 | CKV_K8S_49  | resource | ClusterRole            | Minimize wildcard use in Roles and ClusterRoles                                                                                                                                                | Kubernetes | [WildcardRoles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/WildcardRoles.py)                                                                         |
| 318 | CKV_K8S_49  | resource | Role                   | Minimize wildcard use in Roles and ClusterRoles                                                                                                                                                | Kubernetes | [WildcardRoles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/WildcardRoles.py)                                                                         |
| 319 | CKV_K8S_68  | resource | CronJob                | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 320 | CKV_K8S_68  | resource | DaemonSet              | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 321 | CKV_K8S_68  | resource | Deployment             | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 322 | CKV_K8S_68  | resource | DeploymentConfig       | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 323 | CKV_K8S_68  | resource | Job                    | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 324 | CKV_K8S_68  | resource | Pod                    | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 325 | CKV_K8S_68  | resource | PodTemplate            | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 326 | CKV_K8S_68  | resource | ReplicaSet             | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 327 | CKV_K8S_68  | resource | ReplicationController  | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 328 | CKV_K8S_68  | resource | StatefulSet            | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [ApiServerAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAnonymousAuth.py)                                                       |
| 329 | CKV_K8S_69  | resource | CronJob                | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 330 | CKV_K8S_69  | resource | DaemonSet              | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 331 | CKV_K8S_69  | resource | Deployment             | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 332 | CKV_K8S_69  | resource | DeploymentConfig       | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 333 | CKV_K8S_69  | resource | Job                    | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 334 | CKV_K8S_69  | resource | Pod                    | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 335 | CKV_K8S_69  | resource | PodTemplate            | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 336 | CKV_K8S_69  | resource | ReplicaSet             | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 337 | CKV_K8S_69  | resource | ReplicationController  | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 338 | CKV_K8S_69  | resource | StatefulSet            | Ensure that the --basic-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerBasicAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerBasicAuthFile.py)                                                       |
| 339 | CKV_K8S_70  | resource | CronJob                | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 340 | CKV_K8S_70  | resource | DaemonSet              | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 341 | CKV_K8S_70  | resource | Deployment             | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 342 | CKV_K8S_70  | resource | DeploymentConfig       | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 343 | CKV_K8S_70  | resource | Job                    | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 344 | CKV_K8S_70  | resource | Pod                    | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 345 | CKV_K8S_70  | resource | PodTemplate            | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 346 | CKV_K8S_70  | resource | ReplicaSet             | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 347 | CKV_K8S_70  | resource | ReplicationController  | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 348 | CKV_K8S_70  | resource | StatefulSet            | Ensure that the --token-auth-file argument is not set                                                                                                                                          | Kubernetes | [ApiServerTokenAuthFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTokenAuthFile.py)                                                       |
| 349 | CKV_K8S_71  | resource | CronJob                | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 350 | CKV_K8S_71  | resource | DaemonSet              | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 351 | CKV_K8S_71  | resource | Deployment             | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 352 | CKV_K8S_71  | resource | DeploymentConfig       | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 353 | CKV_K8S_71  | resource | Job                    | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 354 | CKV_K8S_71  | resource | Pod                    | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 355 | CKV_K8S_71  | resource | PodTemplate            | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 356 | CKV_K8S_71  | resource | ReplicaSet             | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 357 | CKV_K8S_71  | resource | ReplicationController  | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 358 | CKV_K8S_71  | resource | StatefulSet            | Ensure that the --kubelet-https argument is set to true                                                                                                                                        | Kubernetes | [ApiServerKubeletHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletHttps.py)                                                         |
| 359 | CKV_K8S_72  | resource | CronJob                | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 360 | CKV_K8S_72  | resource | DaemonSet              | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 361 | CKV_K8S_72  | resource | Deployment             | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 362 | CKV_K8S_72  | resource | DeploymentConfig       | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 363 | CKV_K8S_72  | resource | Job                    | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 364 | CKV_K8S_72  | resource | Pod                    | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 365 | CKV_K8S_72  | resource | PodTemplate            | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 366 | CKV_K8S_72  | resource | ReplicaSet             | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 367 | CKV_K8S_72  | resource | ReplicationController  | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 368 | CKV_K8S_72  | resource | StatefulSet            | Ensure that the --kubelet-client-certificate and --kubelet-client-key arguments are set as appropriate                                                                                         | Kubernetes | [ApiServerKubeletClientCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerKubeletClientCertAndKey.py)                                   |
| 369 | CKV_K8S_73  | resource | CronJob                | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 370 | CKV_K8S_73  | resource | DaemonSet              | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 371 | CKV_K8S_73  | resource | Deployment             | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 372 | CKV_K8S_73  | resource | DeploymentConfig       | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 373 | CKV_K8S_73  | resource | Job                    | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 374 | CKV_K8S_73  | resource | Pod                    | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 375 | CKV_K8S_73  | resource | PodTemplate            | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 376 | CKV_K8S_73  | resource | ReplicaSet             | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 377 | CKV_K8S_73  | resource | ReplicationController  | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 378 | CKV_K8S_73  | resource | StatefulSet            | Ensure that the --kubelet-certificate-authority argument is set as appropriate                                                                                                                 | Kubernetes | [ApiServerkubeletCertificateAuthority.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerkubeletCertificateAuthority.py)                           |
| 379 | CKV_K8S_74  | resource | CronJob                | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 380 | CKV_K8S_74  | resource | DaemonSet              | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 381 | CKV_K8S_74  | resource | Deployment             | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 382 | CKV_K8S_74  | resource | DeploymentConfig       | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 383 | CKV_K8S_74  | resource | Job                    | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 384 | CKV_K8S_74  | resource | Pod                    | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 385 | CKV_K8S_74  | resource | PodTemplate            | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 386 | CKV_K8S_74  | resource | ReplicaSet             | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 387 | CKV_K8S_74  | resource | ReplicationController  | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 388 | CKV_K8S_74  | resource | StatefulSet            | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [ApiServerAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNotAlwaysAllow.py)                   |
| 389 | CKV_K8S_75  | resource | CronJob                | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 390 | CKV_K8S_75  | resource | DaemonSet              | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 391 | CKV_K8S_75  | resource | Deployment             | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 392 | CKV_K8S_75  | resource | DeploymentConfig       | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 393 | CKV_K8S_75  | resource | Job                    | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 394 | CKV_K8S_75  | resource | Pod                    | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 395 | CKV_K8S_75  | resource | PodTemplate            | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 396 | CKV_K8S_75  | resource | ReplicaSet             | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 397 | CKV_K8S_75  | resource | ReplicationController  | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 398 | CKV_K8S_75  | resource | StatefulSet            | Ensure that the --authorization-mode argument includes Node                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeNode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeNode.py)                                       |
| 399 | CKV_K8S_77  | resource | CronJob                | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 400 | CKV_K8S_77  | resource | DaemonSet              | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 401 | CKV_K8S_77  | resource | Deployment             | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 402 | CKV_K8S_77  | resource | DeploymentConfig       | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 403 | CKV_K8S_77  | resource | Job                    | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 404 | CKV_K8S_77  | resource | Pod                    | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 405 | CKV_K8S_77  | resource | PodTemplate            | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 406 | CKV_K8S_77  | resource | ReplicaSet             | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 407 | CKV_K8S_77  | resource | ReplicationController  | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 408 | CKV_K8S_77  | resource | StatefulSet            | Ensure that the --authorization-mode argument includes RBAC                                                                                                                                    | Kubernetes | [ApiServerAuthorizationModeRBAC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuthorizationModeRBAC.py)                                       |
| 409 | CKV_K8S_78  | resource | AdmissionConfiguration | Ensure that the admission control plugin EventRateLimit is set                                                                                                                                 | Kubernetes | [ApiServerAdmissionControlEventRateLimit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlEventRateLimit.py)                     |
| 410 | CKV_K8S_79  | resource | CronJob                | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 411 | CKV_K8S_79  | resource | DaemonSet              | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 412 | CKV_K8S_79  | resource | Deployment             | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 413 | CKV_K8S_79  | resource | DeploymentConfig       | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 414 | CKV_K8S_79  | resource | Job                    | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 415 | CKV_K8S_79  | resource | Pod                    | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 416 | CKV_K8S_79  | resource | PodTemplate            | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 417 | CKV_K8S_79  | resource | ReplicaSet             | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 418 | CKV_K8S_79  | resource | ReplicationController  | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 419 | CKV_K8S_79  | resource | StatefulSet            | Ensure that the admission control plugin AlwaysAdmit is not set                                                                                                                                | Kubernetes | [ApiServerAdmissionControlAlwaysAdmit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAdmissionControlAlwaysAdmit.py)                           |
| 420 | CKV_K8S_80  | resource | CronJob                | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 421 | CKV_K8S_80  | resource | DaemonSet              | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 422 | CKV_K8S_80  | resource | Deployment             | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 423 | CKV_K8S_80  | resource | DeploymentConfig       | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 424 | CKV_K8S_80  | resource | Job                    | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 425 | CKV_K8S_80  | resource | Pod                    | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 426 | CKV_K8S_80  | resource | PodTemplate            | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 427 | CKV_K8S_80  | resource | ReplicaSet             | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 428 | CKV_K8S_80  | resource | ReplicationController  | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 429 | CKV_K8S_80  | resource | StatefulSet            | Ensure that the admission control plugin AlwaysPullImages is set                                                                                                                               | Kubernetes | [ApiServerAlwaysPullImagesPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAlwaysPullImagesPlugin.py)                                     |
| 430 | CKV_K8S_81  | resource | CronJob                | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 431 | CKV_K8S_81  | resource | DaemonSet              | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 432 | CKV_K8S_81  | resource | Deployment             | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 433 | CKV_K8S_81  | resource | DeploymentConfig       | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 434 | CKV_K8S_81  | resource | Job                    | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 435 | CKV_K8S_81  | resource | Pod                    | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 436 | CKV_K8S_81  | resource | PodTemplate            | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 437 | CKV_K8S_81  | resource | ReplicaSet             | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 438 | CKV_K8S_81  | resource | ReplicationController  | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 439 | CKV_K8S_81  | resource | StatefulSet            | Ensure that the admission control plugin SecurityContextDeny is set if PodSecurityPolicy is not used                                                                                           | Kubernetes | [ApiServerSecurityContextDenyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurityContextDenyPlugin.py)                               |
| 440 | CKV_K8S_82  | resource | CronJob                | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 441 | CKV_K8S_82  | resource | DaemonSet              | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 442 | CKV_K8S_82  | resource | Deployment             | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 443 | CKV_K8S_82  | resource | DeploymentConfig       | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 444 | CKV_K8S_82  | resource | Job                    | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 445 | CKV_K8S_82  | resource | Pod                    | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 446 | CKV_K8S_82  | resource | PodTemplate            | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 447 | CKV_K8S_82  | resource | ReplicaSet             | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 448 | CKV_K8S_82  | resource | ReplicationController  | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 449 | CKV_K8S_82  | resource | StatefulSet            | Ensure that the admission control plugin ServiceAccount is set                                                                                                                                 | Kubernetes | [ApiServerServiceAccountPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountPlugin.py)                                         |
| 450 | CKV_K8S_83  | resource | CronJob                | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 451 | CKV_K8S_83  | resource | DaemonSet              | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 452 | CKV_K8S_83  | resource | Deployment             | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 453 | CKV_K8S_83  | resource | DeploymentConfig       | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 454 | CKV_K8S_83  | resource | Job                    | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 455 | CKV_K8S_83  | resource | Pod                    | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 456 | CKV_K8S_83  | resource | PodTemplate            | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 457 | CKV_K8S_83  | resource | ReplicaSet             | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 458 | CKV_K8S_83  | resource | ReplicationController  | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 459 | CKV_K8S_83  | resource | StatefulSet            | Ensure that the admission control plugin NamespaceLifecycle is set                                                                                                                             | Kubernetes | [ApiServerNamespaceLifecyclePlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNamespaceLifecyclePlugin.py)                                 |
| 460 | CKV_K8S_84  | resource | CronJob                | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 461 | CKV_K8S_84  | resource | DaemonSet              | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 462 | CKV_K8S_84  | resource | Deployment             | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 463 | CKV_K8S_84  | resource | DeploymentConfig       | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 464 | CKV_K8S_84  | resource | Job                    | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 465 | CKV_K8S_84  | resource | Pod                    | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 466 | CKV_K8S_84  | resource | PodTemplate            | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 467 | CKV_K8S_84  | resource | ReplicaSet             | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 468 | CKV_K8S_84  | resource | ReplicationController  | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 469 | CKV_K8S_84  | resource | StatefulSet            | Ensure that the admission control plugin PodSecurityPolicy is set                                                                                                                              | Kubernetes | [ApiServerPodSecurityPolicyPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerPodSecurityPolicyPlugin.py)                                   |
| 470 | CKV_K8S_85  | resource | CronJob                | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 471 | CKV_K8S_85  | resource | DaemonSet              | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 472 | CKV_K8S_85  | resource | Deployment             | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 473 | CKV_K8S_85  | resource | DeploymentConfig       | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 474 | CKV_K8S_85  | resource | Job                    | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 475 | CKV_K8S_85  | resource | Pod                    | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 476 | CKV_K8S_85  | resource | PodTemplate            | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 477 | CKV_K8S_85  | resource | ReplicaSet             | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 478 | CKV_K8S_85  | resource | ReplicationController  | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 479 | CKV_K8S_85  | resource | StatefulSet            | Ensure that the admission control plugin NodeRestriction is set                                                                                                                                | Kubernetes | [ApiServerNodeRestrictionPlugin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerNodeRestrictionPlugin.py)                                       |
| 480 | CKV_K8S_86  | resource | CronJob                | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 481 | CKV_K8S_86  | resource | DaemonSet              | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 482 | CKV_K8S_86  | resource | Deployment             | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 483 | CKV_K8S_86  | resource | DeploymentConfig       | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 484 | CKV_K8S_86  | resource | Job                    | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 485 | CKV_K8S_86  | resource | Pod                    | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 486 | CKV_K8S_86  | resource | PodTemplate            | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 487 | CKV_K8S_86  | resource | ReplicaSet             | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 488 | CKV_K8S_86  | resource | ReplicationController  | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 489 | CKV_K8S_86  | resource | StatefulSet            | Ensure that the --insecure-bind-address argument is not set                                                                                                                                    | Kubernetes | [ApiServerInsecureBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecureBindAddress.py)                                           |
| 490 | CKV_K8S_88  | resource | CronJob                | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 491 | CKV_K8S_88  | resource | DaemonSet              | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 492 | CKV_K8S_88  | resource | Deployment             | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 493 | CKV_K8S_88  | resource | DeploymentConfig       | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 494 | CKV_K8S_88  | resource | Job                    | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 495 | CKV_K8S_88  | resource | Pod                    | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 496 | CKV_K8S_88  | resource | PodTemplate            | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 497 | CKV_K8S_88  | resource | ReplicaSet             | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 498 | CKV_K8S_88  | resource | ReplicationController  | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 499 | CKV_K8S_88  | resource | StatefulSet            | Ensure that the --insecure-port argument is set to 0                                                                                                                                           | Kubernetes | [ApiServerInsecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerInsecurePort.py)                                                         |
| 500 | CKV_K8S_89  | resource | CronJob                | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 501 | CKV_K8S_89  | resource | DaemonSet              | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 502 | CKV_K8S_89  | resource | Deployment             | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 503 | CKV_K8S_89  | resource | DeploymentConfig       | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 504 | CKV_K8S_89  | resource | Job                    | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 505 | CKV_K8S_89  | resource | Pod                    | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 506 | CKV_K8S_89  | resource | PodTemplate            | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 507 | CKV_K8S_89  | resource | ReplicaSet             | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 508 | CKV_K8S_89  | resource | ReplicationController  | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 509 | CKV_K8S_89  | resource | StatefulSet            | Ensure that the --secure-port argument is not set to 0                                                                                                                                         | Kubernetes | [ApiServerSecurePort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerSecurePort.py)                                                             |
| 510 | CKV_K8S_90  | resource | CronJob                | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 511 | CKV_K8S_90  | resource | DaemonSet              | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 512 | CKV_K8S_90  | resource | Deployment             | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 513 | CKV_K8S_90  | resource | DeploymentConfig       | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 514 | CKV_K8S_90  | resource | Job                    | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 515 | CKV_K8S_90  | resource | Pod                    | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 516 | CKV_K8S_90  | resource | PodTemplate            | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 517 | CKV_K8S_90  | resource | ReplicaSet             | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 518 | CKV_K8S_90  | resource | ReplicationController  | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 519 | CKV_K8S_90  | resource | StatefulSet            | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [ApiServerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerProfiling.py)                                                               |
| 520 | CKV_K8S_91  | resource | CronJob                | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 521 | CKV_K8S_91  | resource | DaemonSet              | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 522 | CKV_K8S_91  | resource | Deployment             | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 523 | CKV_K8S_91  | resource | DeploymentConfig       | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 524 | CKV_K8S_91  | resource | Job                    | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 525 | CKV_K8S_91  | resource | Pod                    | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 526 | CKV_K8S_91  | resource | PodTemplate            | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 527 | CKV_K8S_91  | resource | ReplicaSet             | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 528 | CKV_K8S_91  | resource | ReplicationController  | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 529 | CKV_K8S_91  | resource | StatefulSet            | Ensure that the --audit-log-path argument is set                                                                                                                                               | Kubernetes | [ApiServerAuditLog.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLog.py)                                                                 |
| 530 | CKV_K8S_92  | resource | CronJob                | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 531 | CKV_K8S_92  | resource | DaemonSet              | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 532 | CKV_K8S_92  | resource | Deployment             | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 533 | CKV_K8S_92  | resource | DeploymentConfig       | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 534 | CKV_K8S_92  | resource | Job                    | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 535 | CKV_K8S_92  | resource | Pod                    | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 536 | CKV_K8S_92  | resource | PodTemplate            | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 537 | CKV_K8S_92  | resource | ReplicaSet             | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 538 | CKV_K8S_92  | resource | ReplicationController  | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 539 | CKV_K8S_92  | resource | StatefulSet            | Ensure that the --audit-log-maxage argument is set to 30 or as appropriate                                                                                                                     | Kubernetes | [ApiServerAuditLogMaxAge.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxAge.py)                                                     |
| 540 | CKV_K8S_93  | resource | CronJob                | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 541 | CKV_K8S_93  | resource | DaemonSet              | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 542 | CKV_K8S_93  | resource | Deployment             | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 543 | CKV_K8S_93  | resource | DeploymentConfig       | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 544 | CKV_K8S_93  | resource | Job                    | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 545 | CKV_K8S_93  | resource | Pod                    | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 546 | CKV_K8S_93  | resource | PodTemplate            | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 547 | CKV_K8S_93  | resource | ReplicaSet             | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 548 | CKV_K8S_93  | resource | ReplicationController  | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 549 | CKV_K8S_93  | resource | StatefulSet            | Ensure that the --audit-log-maxbackup argument is set to 10 or as appropriate                                                                                                                  | Kubernetes | [ApiServerAuditLogMaxBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxBackup.py)                                               |
| 550 | CKV_K8S_94  | resource | CronJob                | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 551 | CKV_K8S_94  | resource | DaemonSet              | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 552 | CKV_K8S_94  | resource | Deployment             | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 553 | CKV_K8S_94  | resource | DeploymentConfig       | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 554 | CKV_K8S_94  | resource | Job                    | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 555 | CKV_K8S_94  | resource | Pod                    | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 556 | CKV_K8S_94  | resource | PodTemplate            | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 557 | CKV_K8S_94  | resource | ReplicaSet             | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 558 | CKV_K8S_94  | resource | ReplicationController  | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 559 | CKV_K8S_94  | resource | StatefulSet            | Ensure that the --audit-log-maxsize argument is set to 100 or as appropriate                                                                                                                   | Kubernetes | [ApiServerAuditLogMaxSize.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerAuditLogMaxSize.py)                                                   |
| 560 | CKV_K8S_95  | resource | CronJob                | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 561 | CKV_K8S_95  | resource | DaemonSet              | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 562 | CKV_K8S_95  | resource | Deployment             | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 563 | CKV_K8S_95  | resource | DeploymentConfig       | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 564 | CKV_K8S_95  | resource | Job                    | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 565 | CKV_K8S_95  | resource | Pod                    | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 566 | CKV_K8S_95  | resource | PodTemplate            | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 567 | CKV_K8S_95  | resource | ReplicaSet             | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 568 | CKV_K8S_95  | resource | ReplicationController  | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 569 | CKV_K8S_95  | resource | StatefulSet            | Ensure that the --request-timeout argument is set as appropriate                                                                                                                               | Kubernetes | [ApiServerRequestTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerRequestTimeout.py)                                                     |
| 570 | CKV_K8S_96  | resource | CronJob                | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 571 | CKV_K8S_96  | resource | DaemonSet              | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 572 | CKV_K8S_96  | resource | Deployment             | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 573 | CKV_K8S_96  | resource | DeploymentConfig       | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 574 | CKV_K8S_96  | resource | Job                    | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 575 | CKV_K8S_96  | resource | Pod                    | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 576 | CKV_K8S_96  | resource | PodTemplate            | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 577 | CKV_K8S_96  | resource | ReplicaSet             | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 578 | CKV_K8S_96  | resource | ReplicationController  | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 579 | CKV_K8S_96  | resource | StatefulSet            | Ensure that the --service-account-lookup argument is set to true                                                                                                                               | Kubernetes | [ApiServerServiceAccountLookup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountLookup.py)                                         |
| 580 | CKV_K8S_97  | resource | CronJob                | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 581 | CKV_K8S_97  | resource | DaemonSet              | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 582 | CKV_K8S_97  | resource | Deployment             | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 583 | CKV_K8S_97  | resource | DeploymentConfig       | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 584 | CKV_K8S_97  | resource | Job                    | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 585 | CKV_K8S_97  | resource | Pod                    | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 586 | CKV_K8S_97  | resource | PodTemplate            | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 587 | CKV_K8S_97  | resource | ReplicaSet             | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 588 | CKV_K8S_97  | resource | ReplicationController  | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 589 | CKV_K8S_97  | resource | StatefulSet            | Ensure that the --service-account-key-file argument is set as appropriate                                                                                                                      | Kubernetes | [ApiServerServiceAccountKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerServiceAccountKeyFile.py)                                       |
| 590 | CKV_K8S_99  | resource | CronJob                | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 591 | CKV_K8S_99  | resource | DaemonSet              | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 592 | CKV_K8S_99  | resource | Deployment             | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 593 | CKV_K8S_99  | resource | DeploymentConfig       | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 594 | CKV_K8S_99  | resource | Job                    | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 595 | CKV_K8S_99  | resource | Pod                    | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 596 | CKV_K8S_99  | resource | PodTemplate            | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 597 | CKV_K8S_99  | resource | ReplicaSet             | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 598 | CKV_K8S_99  | resource | ReplicationController  | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 599 | CKV_K8S_99  | resource | StatefulSet            | Ensure that the --etcd-certfile and --etcd-keyfile arguments are set as appropriate                                                                                                            | Kubernetes | [ApiServerEtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCertAndKey.py)                                                     |
| 600 | CKV_K8S_100 | resource | CronJob                | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 601 | CKV_K8S_100 | resource | DaemonSet              | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 602 | CKV_K8S_100 | resource | Deployment             | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 603 | CKV_K8S_100 | resource | DeploymentConfig       | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 604 | CKV_K8S_100 | resource | Job                    | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 605 | CKV_K8S_100 | resource | Pod                    | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 606 | CKV_K8S_100 | resource | PodTemplate            | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 607 | CKV_K8S_100 | resource | ReplicaSet             | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 608 | CKV_K8S_100 | resource | ReplicationController  | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 609 | CKV_K8S_100 | resource | StatefulSet            | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [ApiServerTlsCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerTlsCertAndKey.py)                                                       |
| 610 | CKV_K8S_102 | resource | CronJob                | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 611 | CKV_K8S_102 | resource | DaemonSet              | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 612 | CKV_K8S_102 | resource | Deployment             | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 613 | CKV_K8S_102 | resource | DeploymentConfig       | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 614 | CKV_K8S_102 | resource | Job                    | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 615 | CKV_K8S_102 | resource | Pod                    | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 616 | CKV_K8S_102 | resource | PodTemplate            | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 617 | CKV_K8S_102 | resource | ReplicaSet             | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 618 | CKV_K8S_102 | resource | ReplicationController  | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 619 | CKV_K8S_102 | resource | StatefulSet            | Ensure that the --etcd-cafile argument is set as appropriate                                                                                                                                   | Kubernetes | [ApiServerEtcdCaFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEtcdCaFile.py)                                                             |
| 620 | CKV_K8S_104 | resource | CronJob                | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 621 | CKV_K8S_104 | resource | DaemonSet              | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 622 | CKV_K8S_104 | resource | Deployment             | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 623 | CKV_K8S_104 | resource | DeploymentConfig       | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 624 | CKV_K8S_104 | resource | Job                    | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 625 | CKV_K8S_104 | resource | Pod                    | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 626 | CKV_K8S_104 | resource | PodTemplate            | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 627 | CKV_K8S_104 | resource | ReplicaSet             | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 628 | CKV_K8S_104 | resource | ReplicationController  | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 629 | CKV_K8S_104 | resource | StatefulSet            | Ensure that encryption providers are appropriately configured                                                                                                                                  | Kubernetes | [ApiServerEncryptionProviders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerEncryptionProviders.py)                                           |
| 630 | CKV_K8S_105 | resource | CronJob                | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 631 | CKV_K8S_105 | resource | DaemonSet              | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 632 | CKV_K8S_105 | resource | Deployment             | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 633 | CKV_K8S_105 | resource | DeploymentConfig       | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 634 | CKV_K8S_105 | resource | Job                    | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 635 | CKV_K8S_105 | resource | Pod                    | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 636 | CKV_K8S_105 | resource | PodTemplate            | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 637 | CKV_K8S_105 | resource | ReplicaSet             | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 638 | CKV_K8S_105 | resource | ReplicationController  | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 639 | CKV_K8S_105 | resource | StatefulSet            | Ensure that the API Server only makes use of Strong Cryptographic Ciphers                                                                                                                      | Kubernetes | [ApiServerStrongCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ApiServerStrongCryptographicCiphers.py)                             |
| 640 | CKV_K8S_106 | resource | CronJob                | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 641 | CKV_K8S_106 | resource | DaemonSet              | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 642 | CKV_K8S_106 | resource | Deployment             | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 643 | CKV_K8S_106 | resource | DeploymentConfig       | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 644 | CKV_K8S_106 | resource | Job                    | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 645 | CKV_K8S_106 | resource | Pod                    | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 646 | CKV_K8S_106 | resource | PodTemplate            | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 647 | CKV_K8S_106 | resource | ReplicaSet             | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 648 | CKV_K8S_106 | resource | ReplicationController  | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 649 | CKV_K8S_106 | resource | StatefulSet            | Ensure that the --terminated-pod-gc-threshold argument is set as appropriate                                                                                                                   | Kubernetes | [KubeControllerManagerTerminatedPods.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerTerminatedPods.py)                             |
| 650 | CKV_K8S_107 | resource | CronJob                | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 651 | CKV_K8S_107 | resource | DaemonSet              | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 652 | CKV_K8S_107 | resource | Deployment             | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 653 | CKV_K8S_107 | resource | DeploymentConfig       | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 654 | CKV_K8S_107 | resource | Job                    | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 655 | CKV_K8S_107 | resource | Pod                    | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 656 | CKV_K8S_107 | resource | PodTemplate            | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 657 | CKV_K8S_107 | resource | ReplicaSet             | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 658 | CKV_K8S_107 | resource | ReplicationController  | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 659 | CKV_K8S_107 | resource | StatefulSet            | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [KubeControllerManagerBlockProfiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerBlockProfiles.py)                               |
| 660 | CKV_K8S_108 | resource | CronJob                | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 661 | CKV_K8S_108 | resource | DaemonSet              | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 662 | CKV_K8S_108 | resource | Deployment             | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 663 | CKV_K8S_108 | resource | DeploymentConfig       | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 664 | CKV_K8S_108 | resource | Job                    | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 665 | CKV_K8S_108 | resource | Pod                    | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 666 | CKV_K8S_108 | resource | PodTemplate            | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 667 | CKV_K8S_108 | resource | ReplicaSet             | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 668 | CKV_K8S_108 | resource | ReplicationController  | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 669 | CKV_K8S_108 | resource | StatefulSet            | Ensure that the --use-service-account-credentials argument is set to true                                                                                                                      | Kubernetes | [KubeControllerManagerServiceAccountCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountCredentials.py)       |
| 670 | CKV_K8S_110 | resource | CronJob                | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 671 | CKV_K8S_110 | resource | DaemonSet              | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 672 | CKV_K8S_110 | resource | Deployment             | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 673 | CKV_K8S_110 | resource | DeploymentConfig       | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 674 | CKV_K8S_110 | resource | Job                    | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 675 | CKV_K8S_110 | resource | Pod                    | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 676 | CKV_K8S_110 | resource | PodTemplate            | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 677 | CKV_K8S_110 | resource | ReplicaSet             | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 678 | CKV_K8S_110 | resource | ReplicationController  | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 679 | CKV_K8S_110 | resource | StatefulSet            | Ensure that the --service-account-private-key-file argument is set as appropriate                                                                                                              | Kubernetes | [KubeControllerManagerServiceAccountPrivateKeyFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerServiceAccountPrivateKeyFile.py) |
| 680 | CKV_K8S_111 | resource | CronJob                | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 681 | CKV_K8S_111 | resource | DaemonSet              | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 682 | CKV_K8S_111 | resource | Deployment             | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 683 | CKV_K8S_111 | resource | DeploymentConfig       | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 684 | CKV_K8S_111 | resource | Job                    | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 685 | CKV_K8S_111 | resource | Pod                    | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 686 | CKV_K8S_111 | resource | PodTemplate            | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 687 | CKV_K8S_111 | resource | ReplicaSet             | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 688 | CKV_K8S_111 | resource | ReplicationController  | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 689 | CKV_K8S_111 | resource | StatefulSet            | Ensure that the --root-ca-file argument is set as appropriate                                                                                                                                  | Kubernetes | [KubeControllerManagerRootCAFile.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeControllerManagerRootCAFile.py)                                     |
| 690 | CKV_K8S_112 | resource | CronJob                | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 691 | CKV_K8S_112 | resource | DaemonSet              | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 692 | CKV_K8S_112 | resource | Deployment             | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 693 | CKV_K8S_112 | resource | DeploymentConfig       | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 694 | CKV_K8S_112 | resource | Job                    | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 695 | CKV_K8S_112 | resource | Pod                    | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 696 | CKV_K8S_112 | resource | PodTemplate            | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 697 | CKV_K8S_112 | resource | ReplicaSet             | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 698 | CKV_K8S_112 | resource | ReplicationController  | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 699 | CKV_K8S_112 | resource | StatefulSet            | Ensure that the RotateKubeletServerCertificate argument is set to true                                                                                                                         | Kubernetes | [RotateKubeletServerCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RotateKubeletServerCertificate.py)                                       |
| 700 | CKV_K8S_113 | resource | CronJob                | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 701 | CKV_K8S_113 | resource | DaemonSet              | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 702 | CKV_K8S_113 | resource | Deployment             | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 703 | CKV_K8S_113 | resource | DeploymentConfig       | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 704 | CKV_K8S_113 | resource | Job                    | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 705 | CKV_K8S_113 | resource | Pod                    | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 706 | CKV_K8S_113 | resource | PodTemplate            | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 707 | CKV_K8S_113 | resource | ReplicaSet             | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 708 | CKV_K8S_113 | resource | ReplicationController  | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 709 | CKV_K8S_113 | resource | StatefulSet            | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [ControllerManagerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/ControllerManagerBindAddress.py)                                           |
| 710 | CKV_K8S_114 | resource | CronJob                | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 711 | CKV_K8S_114 | resource | DaemonSet              | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 712 | CKV_K8S_114 | resource | Deployment             | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 713 | CKV_K8S_114 | resource | DeploymentConfig       | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 714 | CKV_K8S_114 | resource | Job                    | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 715 | CKV_K8S_114 | resource | Pod                    | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 716 | CKV_K8S_114 | resource | PodTemplate            | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 717 | CKV_K8S_114 | resource | ReplicaSet             | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 718 | CKV_K8S_114 | resource | ReplicationController  | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 719 | CKV_K8S_114 | resource | StatefulSet            | Ensure that the --profiling argument is set to false                                                                                                                                           | Kubernetes | [SchedulerProfiling.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerProfiling.py)                                                               |
| 720 | CKV_K8S_115 | resource | CronJob                | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 721 | CKV_K8S_115 | resource | DaemonSet              | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 722 | CKV_K8S_115 | resource | Deployment             | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 723 | CKV_K8S_115 | resource | DeploymentConfig       | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 724 | CKV_K8S_115 | resource | Job                    | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 725 | CKV_K8S_115 | resource | Pod                    | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 726 | CKV_K8S_115 | resource | PodTemplate            | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 727 | CKV_K8S_115 | resource | ReplicaSet             | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 728 | CKV_K8S_115 | resource | ReplicationController  | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 729 | CKV_K8S_115 | resource | StatefulSet            | Ensure that the --bind-address argument is set to 127.0.0.1                                                                                                                                    | Kubernetes | [SchedulerBindAddress.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/SchedulerBindAddress.py)                                                           |
| 730 | CKV_K8S_116 | resource | CronJob                | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 731 | CKV_K8S_116 | resource | DaemonSet              | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 732 | CKV_K8S_116 | resource | Deployment             | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 733 | CKV_K8S_116 | resource | DeploymentConfig       | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 734 | CKV_K8S_116 | resource | Job                    | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 735 | CKV_K8S_116 | resource | Pod                    | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 736 | CKV_K8S_116 | resource | PodTemplate            | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 737 | CKV_K8S_116 | resource | ReplicaSet             | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 738 | CKV_K8S_116 | resource | ReplicationController  | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 739 | CKV_K8S_116 | resource | StatefulSet            | Ensure that the --cert-file and --key-file arguments are set as appropriate                                                                                                                    | Kubernetes | [EtcdCertAndKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdCertAndKey.py)                                                                       |
| 740 | CKV_K8S_117 | resource | CronJob                | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 741 | CKV_K8S_117 | resource | DaemonSet              | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 742 | CKV_K8S_117 | resource | Deployment             | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 743 | CKV_K8S_117 | resource | DeploymentConfig       | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 744 | CKV_K8S_117 | resource | Job                    | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 745 | CKV_K8S_117 | resource | Pod                    | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 746 | CKV_K8S_117 | resource | PodTemplate            | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 747 | CKV_K8S_117 | resource | ReplicaSet             | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 748 | CKV_K8S_117 | resource | ReplicationController  | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 749 | CKV_K8S_117 | resource | StatefulSet            | Ensure that the --client-cert-auth argument is set to true                                                                                                                                     | Kubernetes | [EtcdClientCertAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdClientCertAuth.py)                                                               |
| 750 | CKV_K8S_118 | resource | CronJob                | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 751 | CKV_K8S_118 | resource | DaemonSet              | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 752 | CKV_K8S_118 | resource | Deployment             | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 753 | CKV_K8S_118 | resource | DeploymentConfig       | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 754 | CKV_K8S_118 | resource | Job                    | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 755 | CKV_K8S_118 | resource | Pod                    | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 756 | CKV_K8S_118 | resource | PodTemplate            | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 757 | CKV_K8S_118 | resource | ReplicaSet             | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 758 | CKV_K8S_118 | resource | ReplicationController  | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 759 | CKV_K8S_118 | resource | StatefulSet            | Ensure that the --auto-tls argument is not set to true                                                                                                                                         | Kubernetes | [EtcdAutoTls.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdAutoTls.py)                                                                             |
| 760 | CKV_K8S_119 | resource | CronJob                | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 761 | CKV_K8S_119 | resource | DaemonSet              | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 762 | CKV_K8S_119 | resource | Deployment             | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 763 | CKV_K8S_119 | resource | DeploymentConfig       | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 764 | CKV_K8S_119 | resource | Job                    | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 765 | CKV_K8S_119 | resource | Pod                    | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 766 | CKV_K8S_119 | resource | PodTemplate            | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 767 | CKV_K8S_119 | resource | ReplicaSet             | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 768 | CKV_K8S_119 | resource | ReplicationController  | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 769 | CKV_K8S_119 | resource | StatefulSet            | Ensure that the --peer-cert-file and --peer-key-file arguments are set as appropriate                                                                                                          | Kubernetes | [EtcdPeerFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/EtcdPeerFiles.py)                                                                         |
| 770 | CKV_K8S_121 | resource | Pod                    | Ensure that the --peer-client-cert-auth argument is set to true                                                                                                                                | Kubernetes | [PeerClientCertAuthTrue.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/PeerClientCertAuthTrue.py)                                                       |
| 771 | CKV_K8S_138 | resource | CronJob                | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 772 | CKV_K8S_138 | resource | DaemonSet              | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 773 | CKV_K8S_138 | resource | Deployment             | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 774 | CKV_K8S_138 | resource | DeploymentConfig       | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 775 | CKV_K8S_138 | resource | Job                    | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 776 | CKV_K8S_138 | resource | Pod                    | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 777 | CKV_K8S_138 | resource | PodTemplate            | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 778 | CKV_K8S_138 | resource | ReplicaSet             | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 779 | CKV_K8S_138 | resource | ReplicationController  | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 780 | CKV_K8S_138 | resource | StatefulSet            | Ensure that the --anonymous-auth argument is set to false                                                                                                                                      | Kubernetes | [KubeletAnonymousAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAnonymousAuth.py)                                                           |
| 781 | CKV_K8S_139 | resource | CronJob                | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 782 | CKV_K8S_139 | resource | DaemonSet              | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 783 | CKV_K8S_139 | resource | Deployment             | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 784 | CKV_K8S_139 | resource | DeploymentConfig       | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 785 | CKV_K8S_139 | resource | Job                    | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 786 | CKV_K8S_139 | resource | Pod                    | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 787 | CKV_K8S_139 | resource | PodTemplate            | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 788 | CKV_K8S_139 | resource | ReplicaSet             | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 789 | CKV_K8S_139 | resource | ReplicationController  | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 790 | CKV_K8S_139 | resource | StatefulSet            | Ensure that the --authorization-mode argument is not set to AlwaysAllow                                                                                                                        | Kubernetes | [KubeletAuthorizationModeNotAlwaysAllow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletAuthorizationModeNotAlwaysAllow.py)                       |
| 791 | CKV_K8S_140 | resource | CronJob                | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 792 | CKV_K8S_140 | resource | DaemonSet              | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 793 | CKV_K8S_140 | resource | Deployment             | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 794 | CKV_K8S_140 | resource | DeploymentConfig       | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 795 | CKV_K8S_140 | resource | Job                    | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 796 | CKV_K8S_140 | resource | Pod                    | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 797 | CKV_K8S_140 | resource | PodTemplate            | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 798 | CKV_K8S_140 | resource | ReplicaSet             | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 799 | CKV_K8S_140 | resource | ReplicationController  | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 800 | CKV_K8S_140 | resource | StatefulSet            | Ensure that the --client-ca-file argument is set as appropriate                                                                                                                                | Kubernetes | [KubeletClientCa.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletClientCa.py)                                                                     |
| 801 | CKV_K8S_141 | resource | CronJob                | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 802 | CKV_K8S_141 | resource | DaemonSet              | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 803 | CKV_K8S_141 | resource | Deployment             | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 804 | CKV_K8S_141 | resource | DeploymentConfig       | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 805 | CKV_K8S_141 | resource | Job                    | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 806 | CKV_K8S_141 | resource | Pod                    | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 807 | CKV_K8S_141 | resource | PodTemplate            | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 808 | CKV_K8S_141 | resource | ReplicaSet             | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 809 | CKV_K8S_141 | resource | ReplicationController  | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 810 | CKV_K8S_141 | resource | StatefulSet            | Ensure that the --read-only-port argument is set to 0                                                                                                                                          | Kubernetes | [KubeletReadOnlyPort.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletReadOnlyPort.py)                                                             |
| 811 | CKV_K8S_143 | resource | CronJob                | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 812 | CKV_K8S_143 | resource | DaemonSet              | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 813 | CKV_K8S_143 | resource | Deployment             | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 814 | CKV_K8S_143 | resource | DeploymentConfig       | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 815 | CKV_K8S_143 | resource | Job                    | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 816 | CKV_K8S_143 | resource | Pod                    | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 817 | CKV_K8S_143 | resource | PodTemplate            | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 818 | CKV_K8S_143 | resource | ReplicaSet             | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 819 | CKV_K8S_143 | resource | ReplicationController  | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 820 | CKV_K8S_143 | resource | StatefulSet            | Ensure that the --streaming-connection-idle-timeout argument is not set to 0                                                                                                                   | Kubernetes | [KubeletStreamingConnectionIdleTimeout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletStreamingConnectionIdleTimeout.py)                         |
| 821 | CKV_K8S_144 | resource | CronJob                | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 822 | CKV_K8S_144 | resource | DaemonSet              | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 823 | CKV_K8S_144 | resource | Deployment             | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 824 | CKV_K8S_144 | resource | DeploymentConfig       | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 825 | CKV_K8S_144 | resource | Job                    | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 826 | CKV_K8S_144 | resource | Pod                    | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 827 | CKV_K8S_144 | resource | PodTemplate            | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 828 | CKV_K8S_144 | resource | ReplicaSet             | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 829 | CKV_K8S_144 | resource | ReplicationController  | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 830 | CKV_K8S_144 | resource | StatefulSet            | Ensure that the --protect-kernel-defaults argument is set to true                                                                                                                              | Kubernetes | [KubeletProtectKernelDefaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletProtectKernelDefaults.py)                                           |
| 831 | CKV_K8S_145 | resource | CronJob                | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 832 | CKV_K8S_145 | resource | DaemonSet              | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 833 | CKV_K8S_145 | resource | Deployment             | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 834 | CKV_K8S_145 | resource | DeploymentConfig       | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 835 | CKV_K8S_145 | resource | Job                    | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 836 | CKV_K8S_145 | resource | Pod                    | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 837 | CKV_K8S_145 | resource | PodTemplate            | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 838 | CKV_K8S_145 | resource | ReplicaSet             | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 839 | CKV_K8S_145 | resource | ReplicationController  | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 840 | CKV_K8S_145 | resource | StatefulSet            | Ensure that the --make-iptables-util-chains argument is set to true                                                                                                                            | Kubernetes | [KubeletMakeIptablesUtilChains.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletMakeIptablesUtilChains.py)                                         |
| 841 | CKV_K8S_146 | resource | CronJob                | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 842 | CKV_K8S_146 | resource | DaemonSet              | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 843 | CKV_K8S_146 | resource | Deployment             | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 844 | CKV_K8S_146 | resource | DeploymentConfig       | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 845 | CKV_K8S_146 | resource | Job                    | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 846 | CKV_K8S_146 | resource | Pod                    | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 847 | CKV_K8S_146 | resource | PodTemplate            | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 848 | CKV_K8S_146 | resource | ReplicaSet             | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 849 | CKV_K8S_146 | resource | ReplicationController  | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 850 | CKV_K8S_146 | resource | StatefulSet            | Ensure that the --hostname-override argument is not set                                                                                                                                        | Kubernetes | [KubeletHostnameOverride.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletHostnameOverride.py)                                                     |
| 851 | CKV_K8S_147 | resource | CronJob                | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 852 | CKV_K8S_147 | resource | DaemonSet              | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 853 | CKV_K8S_147 | resource | Deployment             | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 854 | CKV_K8S_147 | resource | DeploymentConfig       | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 855 | CKV_K8S_147 | resource | Job                    | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 856 | CKV_K8S_147 | resource | Pod                    | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 857 | CKV_K8S_147 | resource | PodTemplate            | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 858 | CKV_K8S_147 | resource | ReplicaSet             | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 859 | CKV_K8S_147 | resource | ReplicationController  | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 860 | CKV_K8S_147 | resource | StatefulSet            | Ensure that the --event-qps argument is set to 0 or a level which ensures appropriate event capture                                                                                            | Kubernetes | [KubletEventCapture.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletEventCapture.py)                                                               |
| 861 | CKV_K8S_148 | resource | CronJob                | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 862 | CKV_K8S_148 | resource | DaemonSet              | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 863 | CKV_K8S_148 | resource | Deployment             | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 864 | CKV_K8S_148 | resource | DeploymentConfig       | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 865 | CKV_K8S_148 | resource | Job                    | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 866 | CKV_K8S_148 | resource | Pod                    | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 867 | CKV_K8S_148 | resource | PodTemplate            | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 868 | CKV_K8S_148 | resource | ReplicaSet             | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 869 | CKV_K8S_148 | resource | ReplicationController  | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 870 | CKV_K8S_148 | resource | StatefulSet            | Ensure that the --tls-cert-file and --tls-private-key-file arguments are set as appropriate                                                                                                    | Kubernetes | [KubeletKeyFilesSetAppropriate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletKeyFilesSetAppropriate.py)                                         |
| 871 | CKV_K8S_149 | resource | CronJob                | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 872 | CKV_K8S_149 | resource | DaemonSet              | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 873 | CKV_K8S_149 | resource | Deployment             | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 874 | CKV_K8S_149 | resource | DeploymentConfig       | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 875 | CKV_K8S_149 | resource | Job                    | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 876 | CKV_K8S_149 | resource | Pod                    | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 877 | CKV_K8S_149 | resource | PodTemplate            | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 878 | CKV_K8S_149 | resource | ReplicaSet             | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 879 | CKV_K8S_149 | resource | ReplicationController  | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 880 | CKV_K8S_149 | resource | StatefulSet            | Ensure that the --rotate-certificates argument is not set to false                                                                                                                             | Kubernetes | [KubletRotateCertificates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubletRotateCertificates.py)                                                   |
| 881 | CKV_K8S_151 | resource | CronJob                | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 882 | CKV_K8S_151 | resource | DaemonSet              | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 883 | CKV_K8S_151 | resource | Deployment             | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 884 | CKV_K8S_151 | resource | DeploymentConfig       | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 885 | CKV_K8S_151 | resource | Job                    | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 886 | CKV_K8S_151 | resource | Pod                    | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 887 | CKV_K8S_151 | resource | PodTemplate            | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 888 | CKV_K8S_151 | resource | ReplicaSet             | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 889 | CKV_K8S_151 | resource | ReplicationController  | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 890 | CKV_K8S_151 | resource | StatefulSet            | Ensure that the Kubelet only makes use of Strong Cryptographic Ciphers                                                                                                                         | Kubernetes | [KubeletCryptographicCiphers.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/KubeletCryptographicCiphers.py)                                             |
| 891 | CKV_K8S_152 | resource | Ingress                | Prevent NGINX Ingress annotation snippets which contain LUA code execution. See CVE-2021-25742                                                                                                 | Kubernetes | [NginxIngressCVE202125742Lua.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/NginxIngressCVE202125742Lua.py)                                             |
| 892 | CKV_K8S_153 | resource | Ingress                | Prevent All NGINX Ingress annotation snippets. See CVE-2021-25742                                                                                                                              | Kubernetes | [NginxIngressCVE202125742AllSnippets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/NginxIngressCVE202125742AllSnippets.py)                             |
| 893 | CKV_K8S_154 | resource | Ingress                | Prevent NGINX Ingress annotation snippets which contain alias statements See CVE-2021-25742                                                                                                    | Kubernetes | [NginxIngressCVE202125742Alias.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/NginxIngressCVE202125742Alias.py)                                         |
| 894 | CKV_K8S_155 | resource | ClusterRole            | Minimize ClusterRoles that grant control over validating or mutating admission webhook configurations                                                                                          | Kubernetes | [RbacControlWebhooks.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RbacControlWebhooks.py)                                                             |
| 895 | CKV_K8S_156 | resource | ClusterRole            | Minimize ClusterRoles that grant permissions to approve CertificateSigningRequests                                                                                                             | Kubernetes | [RbacApproveCertificateSigningRequests.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RbacApproveCertificateSigningRequests.py)                         |
| 896 | CKV_K8S_157 | resource | ClusterRole            | Minimize Roles and ClusterRoles that grant permissions to bind RoleBindings or ClusterRoleBindings                                                                                             | Kubernetes | [RbacBindRoleBindings.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RbacBindRoleBindings.py)                                                           |
| 897 | CKV_K8S_157 | resource | Role                   | Minimize Roles and ClusterRoles that grant permissions to bind RoleBindings or ClusterRoleBindings                                                                                             | Kubernetes | [RbacBindRoleBindings.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RbacBindRoleBindings.py)                                                           |
| 898 | CKV_K8S_158 | resource | ClusterRole            | Minimize Roles and ClusterRoles that grant permissions to escalate Roles or ClusterRoles                                                                                                       | Kubernetes | [RbacEscalateRoles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RbacEscalateRoles.py)                                                                 |
| 899 | CKV_K8S_158 | resource | Role                   | Minimize Roles and ClusterRoles that grant permissions to escalate Roles or ClusterRoles                                                                                                       | Kubernetes | [RbacEscalateRoles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/RbacEscalateRoles.py)                                                                 |
| 900 | CKV_K8S_159 | resource | CronJob                | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 901 | CKV_K8S_159 | resource | DaemonSet              | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 902 | CKV_K8S_159 | resource | Deployment             | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 903 | CKV_K8S_159 | resource | DeploymentConfig       | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 904 | CKV_K8S_159 | resource | Job                    | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 905 | CKV_K8S_159 | resource | Pod                    | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 906 | CKV_K8S_159 | resource | PodTemplate            | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 907 | CKV_K8S_159 | resource | ReplicaSet             | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 908 | CKV_K8S_159 | resource | ReplicationController  | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 909 | CKV_K8S_159 | resource | StatefulSet            | Limit the use of git-sync to prevent code injection                                                                                                                                            | Kubernetes | [DangerousGitSync.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/resource/k8s/DangerousGitSync.py)                                                                   |
| 910 | CKV2_K8S_1  | resource | ClusterRole            | RoleBinding should not allow privilege escalation to a ServiceAccount or Node on other RoleBinding                                                                                             | Kubernetes | [RoleBindingPE.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/RoleBindingPE.yaml)                                                                     |
| 911 | CKV2_K8S_1  | resource | ClusterRoleBinding     | RoleBinding should not allow privilege escalation to a ServiceAccount or Node on other RoleBinding                                                                                             | Kubernetes | [RoleBindingPE.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/RoleBindingPE.yaml)                                                                     |
| 912 | CKV2_K8S_1  | resource | Role                   | RoleBinding should not allow privilege escalation to a ServiceAccount or Node on other RoleBinding                                                                                             | Kubernetes | [RoleBindingPE.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/RoleBindingPE.yaml)                                                                     |
| 913 | CKV2_K8S_1  | resource | RoleBinding            | RoleBinding should not allow privilege escalation to a ServiceAccount or Node on other RoleBinding                                                                                             | Kubernetes | [RoleBindingPE.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/RoleBindingPE.yaml)                                                                     |
| 914 | CKV2_K8S_2  | resource | ClusterRole            | Granting `create` permissions to `nodes/proxy` or `pods/exec` sub resources allows potential privilege escalation                                                                              | Kubernetes | [NoCreateNodesProxyOrPodsExec.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/NoCreateNodesProxyOrPodsExec.yaml)                                       |
| 915 | CKV2_K8S_2  | resource | ClusterRoleBinding     | Granting `create` permissions to `nodes/proxy` or `pods/exec` sub resources allows potential privilege escalation                                                                              | Kubernetes | [NoCreateNodesProxyOrPodsExec.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/NoCreateNodesProxyOrPodsExec.yaml)                                       |
| 916 | CKV2_K8S_2  | resource | Role                   | Granting `create` permissions to `nodes/proxy` or `pods/exec` sub resources allows potential privilege escalation                                                                              | Kubernetes | [NoCreateNodesProxyOrPodsExec.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/NoCreateNodesProxyOrPodsExec.yaml)                                       |
| 917 | CKV2_K8S_2  | resource | RoleBinding            | Granting `create` permissions to `nodes/proxy` or `pods/exec` sub resources allows potential privilege escalation                                                                              | Kubernetes | [NoCreateNodesProxyOrPodsExec.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/NoCreateNodesProxyOrPodsExec.yaml)                                       |
| 918 | CKV2_K8S_3  | resource | ClusterRole            | No ServiceAccount/Node should have `impersonate` permissions for groups/users/service-accounts                                                                                                 | Kubernetes | [ImpersonatePermissions.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ImpersonatePermissions.yaml)                                                   |
| 919 | CKV2_K8S_3  | resource | ClusterRoleBinding     | No ServiceAccount/Node should have `impersonate` permissions for groups/users/service-accounts                                                                                                 | Kubernetes | [ImpersonatePermissions.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ImpersonatePermissions.yaml)                                                   |
| 920 | CKV2_K8S_3  | resource | Role                   | No ServiceAccount/Node should have `impersonate` permissions for groups/users/service-accounts                                                                                                 | Kubernetes | [ImpersonatePermissions.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ImpersonatePermissions.yaml)                                                   |
| 921 | CKV2_K8S_3  | resource | RoleBinding            | No ServiceAccount/Node should have `impersonate` permissions for groups/users/service-accounts                                                                                                 | Kubernetes | [ImpersonatePermissions.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ImpersonatePermissions.yaml)                                                   |
| 922 | CKV2_K8S_4  | resource | ClusterRole            | ServiceAccounts and nodes that can modify services/status may set the `status.loadBalancer.ingress.ip` field to exploit the unfixed CVE-2020-8554 and launch MiTM attacks against the cluster. | Kubernetes | [ModifyServicesStatus.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ModifyServicesStatus.yaml)                                                       |
| 923 | CKV2_K8S_4  | resource | ClusterRoleBinding     | ServiceAccounts and nodes that can modify services/status may set the `status.loadBalancer.ingress.ip` field to exploit the unfixed CVE-2020-8554 and launch MiTM attacks against the cluster. | Kubernetes | [ModifyServicesStatus.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ModifyServicesStatus.yaml)                                                       |
| 924 | CKV2_K8S_4  | resource | Role                   | ServiceAccounts and nodes that can modify services/status may set the `status.loadBalancer.ingress.ip` field to exploit the unfixed CVE-2020-8554 and launch MiTM attacks against the cluster. | Kubernetes | [ModifyServicesStatus.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ModifyServicesStatus.yaml)                                                       |
| 925 | CKV2_K8S_4  | resource | RoleBinding            | ServiceAccounts and nodes that can modify services/status may set the `status.loadBalancer.ingress.ip` field to exploit the unfixed CVE-2020-8554 and launch MiTM attacks against the cluster. | Kubernetes | [ModifyServicesStatus.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ModifyServicesStatus.yaml)                                                       |
| 926 | CKV2_K8S_5  | resource | ClusterRole            | No ServiceAccount/Node should be able to read all secrets                                                                                                                                      | Kubernetes | [ReadAllSecrets.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ReadAllSecrets.yaml)                                                                   |
| 927 | CKV2_K8S_5  | resource | ClusterRoleBinding     | No ServiceAccount/Node should be able to read all secrets                                                                                                                                      | Kubernetes | [ReadAllSecrets.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ReadAllSecrets.yaml)                                                                   |
| 928 | CKV2_K8S_5  | resource | Role                   | No ServiceAccount/Node should be able to read all secrets                                                                                                                                      | Kubernetes | [ReadAllSecrets.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ReadAllSecrets.yaml)                                                                   |
| 929 | CKV2_K8S_5  | resource | RoleBinding            | No ServiceAccount/Node should be able to read all secrets                                                                                                                                      | Kubernetes | [ReadAllSecrets.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/ReadAllSecrets.yaml)                                                                   |
| 930 | CKV2_K8S_6  | resource | Deployment             | Minimize the admission of pods which lack an associated NetworkPolicy                                                                                                                          | Kubernetes | [RequireAllPodsToHaveNetworkPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/RequireAllPodsToHaveNetworkPolicy.yaml)                             |
| 931 | CKV2_K8S_6  | resource | Pod                    | Minimize the admission of pods which lack an associated NetworkPolicy                                                                                                                          | Kubernetes | [RequireAllPodsToHaveNetworkPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/kubernetes/checks/graph_checks/RequireAllPodsToHaveNetworkPolicy.yaml)                             |


---


